/*
 * Decompiled with CFR 0.152.
 */
package fequtl;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class BranchTableModel
extends AbstractTableModel {
    String[] colnames = new String[]{"", "Branch", ""};
    boolean[] display;
    String[] branches = new String[0];
    String[] error;

    public BranchTableModel(XYSeriesCollection in) {
        ArrayList<String> temp = new ArrayList<String>();
        for (XYSeries set : in.getSeries()) {
            temp.add((String)((Object)set.getKey()));
        }
        this.branches = temp.toArray(this.branches);
        this.display = new boolean[this.branches.length];
        this.error = new String[this.branches.length];
        this.sort();
        int i = 0;
        while (i < this.branches.length) {
            this.display[i] = false;
            this.error[i] = in.getSeries((Comparable)((Object)this.branches[i])).isEmpty() ? "ERROR" : "";
            ++i;
        }
    }

    public void sort() {
        int sorted = this.branches.length;
        int length = 1;
        Arrays.sort(this.branches);
        while (sorted > 0) {
            int i = 0;
            while (i < sorted) {
                if (this.branches[i].length() == length) {
                    this.insert(i, this.branches.length - 1);
                    --sorted;
                    continue;
                }
                ++i;
            }
            ++length;
        }
    }

    public void reverse() {
        int i = 0;
        while (i < this.branches.length) {
            this.insert(this.branches.length - 1, i);
            ++i;
        }
    }

    private void insert(int from, int to) {
        boolean temp1 = this.display[from];
        String temp2 = this.branches[from];
        String temp3 = this.error[from];
        int step = from < to ? 1 : -1;
        int i = from;
        while (i != to) {
            this.display[i] = this.display[i + step];
            this.branches[i] = this.branches[i + step];
            this.error[i] = this.error[i + step];
            i += step;
        }
        this.display[to] = temp1;
        this.branches[to] = temp2;
        this.error[to] = temp3;
    }

    @Override
    public int getColumnCount() {
        return this.colnames.length;
    }

    @Override
    public String getColumnName(int col) {
        return this.colnames[col];
    }

    @Override
    public int getRowCount() {
        return this.branches.length;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return Object.class;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.display[row];
            }
            case 1: {
                return this.branches[row];
            }
            case 2: {
                return this.error[row];
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object in, int row, int col) {
        this.changeValueAt(row);
    }

    public void changeValueAt(int row) {
        if (this.error[row] == "") {
            this.display[row] = (Boolean)this.getValueAt(row, 0) == false;
        }
    }
}

