/*
 * Decompiled with CFR 0.152.
 */
package fequtl;

import fequtl.CulvertXYDataItem;
import fequtl.FeqCommand;
import fequtl.FeqxData;
import fequtl.State;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;

public class CulvertData
extends FeqCommand {
    private String filename;
    private String gisid;
    private final String gisidSearch = "GISID";
    private String id;
    private final String idSearch = ".*(TABID|TABLE#).*";
    private int tabtyp;
    private final String tabtypSearch = "TYPE";
    private String label;
    private final String labelSearch = "LABEL";
    private final String dataSearch = "OFFSET";
    private final String endSearch = "POWER";
    private final int[] dataColWidths = new int[]{10, 20, 30, 40};
    private String conId;
    private final String conIdSearch = "NODE ";
    private double prevCrest = 0.0;
    private double prevApproach = 0.0;
    LineNumberReader br;

    public CulvertData(String filename) {
        this.filename = filename;
    }

    public String getConID() {
        return this.conId;
    }

    public void setConID(String conId) {
        this.conId = conId;
    }

    @Override
    public String getTitle() {
        return this.id;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void parseData(LineNumberReader br) {
        try {
            String line;
            this.br = br;
            XYSeries crestSeries = null;
            XYSeries approachSeries = null;
            State s = State.HEADER;
            while ((line = this.br.readLine()) != null) {
                if (line.startsWith(";") || line.startsWith("*")) continue;
                switch (s) {
                    case HEADER: {
                        if (line.startsWith("GISID")) {
                            this.gisid = line.substring(line.indexOf("GISID") + 6).trim();
                            break;
                        }
                        if (line.matches(".*(TABID|TABLE#).*")) {
                            int offset = line.contains("TABID") ? 6 : 7;
                            this.id = line.substring(line.indexOf("TAB") + offset).trim().split("\\s+")[0];
                            break;
                        }
                        if (line.startsWith("TYPE")) {
                            this.tabtyp = Integer.parseInt(line.substring(line.indexOf("TYPE") + "TYPE".length() + 1).trim());
                            break;
                        }
                        if (line.startsWith("LABEL")) {
                            this.label = line.substring(line.indexOf("LABEL") + "LABEL".length() + 1).trim();
                            break;
                        }
                        if (!line.trim().startsWith("NODE ")) break;
                        line = this.br.readLine();
                        while (line.contains("*") || line.contains(";")) {
                            line = this.br.readLine();
                        }
                        this.conId = line.substring(14, 22).trim();
                        String[] test = this.conId.split("\\s+");
                        if (test.length == 2) {
                            this.conId = test[0].length() > test[1].length() ? test[0] : test[1];
                        } else if (test.length == 3) {
                            this.conId = test[1];
                        }
                        s = State.PRE;
                        break;
                    }
                    case PRE: {
                        if (!line.contains("OFFSET")) break;
                        crestSeries = new XYSeries((Comparable)((Object)"Crest"));
                        approachSeries = new XYSeries((Comparable)((Object)"Approach"));
                        s = State.DATA;
                        break;
                    }
                    case DATA: {
                        CulvertXYDataItem approachpoint;
                        CulvertXYDataItem crestpoint;
                        List thisdata = this.splitString(line);
                        if (((String)thisdata.get(1)).equals("")) {
                            crestpoint = new CulvertXYDataItem(Double.parseDouble((String)thisdata.get(0)), this.prevCrest);
                        } else {
                            crestpoint = new CulvertXYDataItem(Double.parseDouble((String)thisdata.get(0)), Double.parseDouble((String)thisdata.get(1)));
                            this.prevCrest = Double.parseDouble((String)thisdata.get(1));
                        }
                        if (thisdata.size() < 4) {
                            approachpoint = new CulvertXYDataItem(Double.parseDouble((String)thisdata.get(0)), this.prevApproach);
                            if (thisdata.size() == 3 && !((String)thisdata.get(2)).equals("")) {
                                crestpoint.setWidth(Double.parseDouble((String)thisdata.get(2)));
                            }
                        } else {
                            if (((String)thisdata.get(3)).equals("")) {
                                approachpoint = new CulvertXYDataItem(Double.parseDouble((String)thisdata.get(0)), this.prevApproach);
                            } else {
                                approachpoint = new CulvertXYDataItem(Double.parseDouble((String)thisdata.get(0)), Double.parseDouble((String)thisdata.get(3)));
                                this.prevApproach = Double.parseDouble((String)thisdata.get(3));
                            }
                            if (!((String)thisdata.get(2)).equals("")) {
                                crestpoint.setWidth(Double.parseDouble((String)thisdata.get(2)));
                            }
                            if (thisdata.size() == 5) {
                                crestpoint.setNote((String)thisdata.get(4));
                            }
                        }
                        crestSeries.add((XYDataItem)crestpoint);
                        approachSeries.add((XYDataItem)approachpoint);
                        if (!line.contains("END")) break;
                        this.data.addSeries(crestSeries);
                        this.data.addSeries(approachSeries);
                        return;
                    }
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(CulvertData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private List splitString(String input) {
        int prev = 0;
        ArrayList<String> l = new ArrayList<String>();
        int[] nArray = this.dataColWidths;
        int n = this.dataColWidths.length;
        int n2 = 0;
        while (n2 < n) {
            int w = nArray[n2];
            try {
                l.add(input.substring(prev, w).trim());
            }
            catch (IndexOutOfBoundsException e) {
                Logger.getLogger(FeqxData.class.getName()).log(Level.SEVERE, input, e);
                break;
            }
            prev = w;
            ++n2;
        }
        try {
            l.add(input.substring(prev).trim());
        }
        catch (IndexOutOfBoundsException e) {
            Logger.getLogger(FeqxData.class.getName()).log(Level.SEVERE, input, e);
        }
        return l;
    }

    @Override
    public String getDesc() {
        return this.label;
    }

    @Override
    public String getType() {
        return "CULVERT";
    }
}

