/*
 * Decompiled with CFR 0.152.
 */
package fequtl;

import fequtl.CulvertXYDataItem;
import fequtl.FeqCommand;
import fequtl.FeqxData;
import fequtl.FtlDataRenderer;
import fequtl.MulconData;
import fequtl.Pipe;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.AbstractXYAnnotation;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.annotations.XYPolygonAnnotation;
import org.jfree.chart.annotations.XYShapeAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.Layer;

public class CulvertFtlView
extends JFrame
implements ChartMouseListener {
    private JPanel CulvertDashboard;
    private JPanel displayPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JTextField noteField;
    private JTextField widthField;
    private JTextField xCoord;
    private JTextField yCoord;
    private JMenuBar menuBar;
    private JMenu mnAnnotations;
    private JMenuItem mntmNew;
    private JMenuItem mntmClearPrevious;
    private JMenuItem mntmClearAll;
    private XYSeriesCollection datasets;
    private ChartPanel chartPanel;
    private FtlDataRenderer newrenderer;
    private String title;
    private JFreeChart chart;
    private String userText = "";
    private boolean addingAnnotation = false;

    public CulvertFtlView(FeqCommand input) {
        this.initComponents();
        this.title = String.valueOf(input.getTitle()) + " " + input.getFilename();
        this.setTitle(this.title);
        this.datasets = input.getData();
        this.chart = this.createChart();
        Plot plot = this.chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        XYPlot xyPlot = this.chart.getXYPlot();
        xyPlot.setDomainGridlinesVisible(true);
        xyPlot.setRangeGridlinesVisible(true);
        xyPlot.setRangeGridlinePaint((Paint)Color.DARK_GRAY);
        xyPlot.setDomainGridlinePaint((Paint)Color.DARK_GRAY);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setPreferredSize(this.displayPanel.getPreferredSize());
        this.chartPanel.setDomainZoomable(true);
        this.chartPanel.setRangeZoomable(true);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder());
        this.chartPanel.setBorder((Border)border);
        this.displayPanel.add((Component)this.chartPanel);
        this.chartPanel.setSize(this.displayPanel.getSize());
        this.chartPanel.addChartMouseListener((ChartMouseListener)this);
        this.chart.removeLegend();
        this.chart.setTitle(this.title);
        this.jLabel6.setText("* No Mulcon found *");
    }

    CulvertFtlView(FeqCommand d, FeqCommand s) {
        this(d);
        XYPlot xyplot = this.chart.getXYPlot();
        if (s instanceof FeqxData) {
            XYSeries series = s.getData().getSeries(0);
            double[] polypoints = new double[series.getItemCount() * 2];
            double yoffset = 0.0;
            if (series.getMinY() < this.datasets.getSeries(1).getMinY() - 50.0) {
                yoffset = this.datasets.getSeries(1).getMinY() - series.getMinY();
            }
            int i = 0;
            while (i < series.getItemCount()) {
                polypoints[i * 2] = series.getX(i).doubleValue();
                polypoints[i * 2 + 1] = series.getY(i).doubleValue() + yoffset;
                ++i;
            }
            XYPolygonAnnotation xypolygonannotation = new XYPolygonAnnotation(polypoints, (Stroke)new BasicStroke(), (Paint)Color.BLACK, null);
            xyplot.getRenderer().addAnnotation((XYAnnotation)xypolygonannotation, Layer.BACKGROUND);
            this.jLabel6.setText("");
        } else {
            Pipe[] pipes;
            MulconData m = (MulconData)s;
            double minY = this.datasets.getSeries(1).getMinY();
            XYDataItem minYPoint = null;
            for (XYDataItem item : this.datasets.getSeries(1).getItems()) {
                if (item.getYValue() != minY) continue;
                minYPoint = item;
                break;
            }
            double sum = 0.0;
            Pipe[] pipeArray = pipes = m.getPipes();
            int n = pipes.length;
            int n2 = 0;
            while (n2 < n) {
                Pipe p = pipeArray[n2];
                sum += p.getSpan();
                ++n2;
            }
            double X = minYPoint.getXValue() - sum / 2.0;
            int i = 0;
            while (i < pipes.length) {
                RectangularShape e = null;
                MulconData.MulconType t = pipes[i].getType();
                if (t.equals((Object)MulconData.MulconType.CIRC) || t.equals((Object)MulconData.MulconType.TE) || t.equals((Object)MulconData.MulconType.NHE) || t.equals((Object)MulconData.MulconType.NVE)) {
                    e = new Ellipse2D.Double(X, minY, pipes[i].getSpan(), pipes[i].getRise());
                } else if (t.equals((Object)MulconData.MulconType.BOX)) {
                    e = new Rectangle2D.Double(X, minY, pipes[i].getSpan(), pipes[i].getRise());
                } else if (t.equals((Object)MulconData.MulconType.RCPA) || t.equals((Object)MulconData.MulconType.CMPA) || t.equals((Object)MulconData.MulconType.CMPAB) || t.equals((Object)MulconData.MulconType.CMPA1) || t.equals((Object)MulconData.MulconType.CMPA1B) || t.equals((Object)MulconData.MulconType.SPPA18) || t.equals((Object)MulconData.MulconType.SPPA31)) {
                    e = new Arc2D.Double(X, minY - pipes[i].getRise(), pipes[i].getSpan(), pipes[i].getRise() * 2.0, 180.0, 180.0, 0);
                }
                if (t == MulconData.MulconType.OTHER || e == null) {
                    this.jLabel6.setText("* Could Not Shape Unknown Culvert Type *");
                    xyplot.addAnnotation((XYAnnotation)new XYLineAnnotation(X, minY, X + pipes[i].getSpan(), minY + pipes[i].getRise(), (Stroke)new BasicStroke(1.0f), (Paint)Color.BLACK));
                    xyplot.addAnnotation((XYAnnotation)new XYLineAnnotation(X, minY + pipes[i].getRise(), X + pipes[i].getSpan(), minY, (Stroke)new BasicStroke(1.0f), (Paint)Color.BLACK));
                } else {
                    this.jLabel6.setText("");
                    xyplot.getRenderer().addAnnotation((XYAnnotation)new XYShapeAnnotation((Shape)e, (Stroke)new BasicStroke(1.0f), (Paint)Color.BLACK), Layer.BACKGROUND);
                }
                xyplot.getRenderer().addAnnotation((XYAnnotation)new XYTextAnnotation(Double.toString(pipes[i].getRoug()), X + pipes[i].getSpan() / 2.0, minY + pipes[i].getRise() + 0.5));
                X += pipes[i].getSpan();
                ++i;
            }
        }
    }

    private void initComponents() {
        this.displayPanel = new JPanel();
        this.CulvertDashboard = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.xCoord = new JTextField();
        this.yCoord = new JTextField();
        this.jLabel4 = new JLabel();
        this.noteField = new JTextField();
        this.jLabel5 = new JLabel();
        this.widthField = new JTextField();
        this.jLabel6 = new JLabel();
        this.menuBar = new JMenuBar();
        this.mnAnnotations = new JMenu();
        this.mntmNew = new JMenuItem();
        this.mntmClearPrevious = new JMenuItem();
        this.mntmClearAll = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setMinimumSize(new Dimension(551, 412));
        this.displayPanel.setLayout(new BorderLayout());
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Click on a point for information.");
        this.jLabel2.setText("X Coordinate:");
        this.jLabel3.setText("Y Coordinate:");
        this.xCoord.setText("0");
        this.xCoord.setFocusable(true);
        this.xCoord.setEditable(false);
        this.xCoord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CulvertFtlView.this.xCoordActionPerformed(evt);
            }
        });
        this.yCoord.setText("0");
        this.yCoord.setFocusable(true);
        this.yCoord.setEditable(false);
        this.jLabel4.setText("Note:");
        this.noteField.setFocusable(true);
        this.noteField.setEditable(false);
        this.noteField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CulvertFtlView.this.noteFieldActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Width Value:");
        this.widthField.setFocusable(true);
        this.widthField.setEditable(false);
        this.widthField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CulvertFtlView.this.widthFieldActionPerformed(evt);
            }
        });
        this.jLabel6.setText("");
        this.setJMenuBar(this.menuBar);
        this.mnAnnotations.setText("Annotations");
        this.menuBar.add(this.mnAnnotations);
        this.mntmNew.setText("New");
        this.mntmNew.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.mntmNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CulvertFtlView.this.newAnnotation(evt);
            }
        });
        this.mnAnnotations.add(this.mntmNew);
        this.mntmClearPrevious.setText("Clear Previous");
        this.mntmClearPrevious.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.mntmClearPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CulvertFtlView.this.clearPrevAnnotation(evt);
            }
        });
        this.mnAnnotations.add(this.mntmClearPrevious);
        this.mntmClearAll.setText("Clear All");
        this.mntmClearAll.setAccelerator(KeyStroke.getKeyStroke(90, 3));
        this.mntmClearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CulvertFtlView.this.clearAllAnnotation(evt);
            }
        });
        this.mnAnnotations.add(this.mntmClearAll);
        GroupLayout CulvertDashboardLayout = new GroupLayout(this.CulvertDashboard);
        CulvertDashboardLayout.setHorizontalGroup(CulvertDashboardLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(CulvertDashboardLayout.createSequentialGroup().addContainerGap().addGroup(CulvertDashboardLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(CulvertDashboardLayout.createSequentialGroup().addGroup(CulvertDashboardLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(CulvertDashboardLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yCoord)).addGroup(CulvertDashboardLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xCoord, -2, 60, -2))).addGap(36).addGroup(CulvertDashboardLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(CulvertDashboardLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noteField, -1, 300, Short.MAX_VALUE).addComponent(this.widthField, -2, 69, -2)).addContainerGap()).addGroup(CulvertDashboardLayout.createSequentialGroup().addComponent(this.jLabel6).addGap(145).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGap(200)))));
        CulvertDashboardLayout.setVerticalGroup(CulvertDashboardLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(CulvertDashboardLayout.createSequentialGroup().addGroup(CulvertDashboardLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(CulvertDashboardLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.xCoord, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.noteField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(CulvertDashboardLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.yCoord, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.widthField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.CulvertDashboard.setLayout(CulvertDashboardLayout);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.CulvertDashboard, -1, -1, Short.MAX_VALUE).addComponent(this.displayPanel, -1, 551, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.displayPanel, -1, 329, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.CulvertDashboard, -2, -1, -2)));
        this.pack();
    }

    private void xCoordActionPerformed(ActionEvent evt) {
    }

    private void noteFieldActionPerformed(ActionEvent evt) {
    }

    private void widthFieldActionPerformed(ActionEvent evt) {
    }

    private void newAnnotation(ActionEvent evt) {
        JOptionPane annotationPane = new JOptionPane();
        this.userText = JOptionPane.showInputDialog("After entering your text, click on the chart \nwhere you want the annotations to be:\n\n");
        if (this.userText != null && !this.userText.equals("")) {
            this.addingAnnotation = true;
        }
    }

    private void clearPrevAnnotation(ActionEvent evt) {
        XYPlot xyplot = this.chart.getXYPlot();
        List current = xyplot.getAnnotations();
        if (!current.isEmpty()) {
            current.remove(current.size() - 1);
            xyplot.clearAnnotations();
            for (AbstractXYAnnotation note : current) {
                xyplot.addAnnotation((XYAnnotation)note);
            }
        }
    }

    private void clearAllAnnotation(ActionEvent evt) {
        XYPlot xyplot = this.chart.getXYPlot();
        xyplot.clearAnnotations();
    }

    public void chartMouseClicked(ChartMouseEvent event) {
        this.chartPanel.setSize(this.displayPanel.getSize());
        ChartEntity chartentity = event.getEntity();
        if (chartentity != null && chartentity instanceof XYItemEntity) {
            XYItemEntity point = (XYItemEntity)chartentity;
            CulvertXYDataItem item = (CulvertXYDataItem)((Object)((XYSeriesCollection)point.getDataset()).getSeries(point.getSeriesIndex()).getItems().get(point.getItem()));
            this.xCoord.setText(String.valueOf(item.getXValue()));
            this.yCoord.setText(String.valueOf(item.getYValue()));
            this.noteField.setText(item.getNote());
            this.widthField.setText(String.valueOf(item.getWidth()));
            this.newrenderer.setHighlightedItem(point.getSeriesIndex(), point.getItem());
        } else {
            this.xCoord.setText("0");
            this.yCoord.setText("0");
            this.noteField.setText("");
            this.widthField.setText("");
            this.newrenderer.setHighlightedItem(-1, -1);
        }
        if (this.addingAnnotation) {
            double x = event.getTrigger().getX();
            double y = event.getTrigger().getY();
            Rectangle2D plotArea = this.chartPanel.getScreenDataArea();
            XYPlot xyplot = this.chart.getXYPlot();
            x = xyplot.getDomainAxis().java2DToValue(x, plotArea, xyplot.getDomainAxisEdge());
            y = xyplot.getRangeAxis().java2DToValue(y, plotArea, xyplot.getRangeAxisEdge());
            xyplot.addAnnotation((XYAnnotation)new XYTextAnnotation(this.userText, x, y));
            this.userText = "";
        }
    }

    public void chartMouseMoved(ChartMouseEvent event) {
    }

    private JFreeChart createChart() {
        JFreeChart newchart = ChartFactory.createXYLineChart(null, (String)"Distance", (String)"Depth", (XYDataset)this.datasets, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot xyplot = newchart.getXYPlot();
        this.newrenderer = new FtlDataRenderer();
        this.newrenderer.setUseFillPaint(true);
        this.newrenderer.setUseOutlinePaint(true);
        xyplot.setRenderer((XYItemRenderer)this.newrenderer);
        ((NumberAxis)xyplot.getRangeAxis()).setAutoRangeIncludesZero(false);
        xyplot.getRangeAxis().setAutoRange(true);
        return newchart;
    }
}

