/*
 * Decompiled with CFR 0.152.
 */
package fequtl;

import fequtl.BranchData;
import fequtl.BranchDataItem;
import fequtl.BranchTableModel;
import fequtl.FtlDataRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class FeqBranchView
extends JFrame
implements ChartMouseListener {
    private JPanel displayPanel;
    private JPanel Dashboard;
    private JScrollPane scroll;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JTextField bnumField;
    private JTextField xnumField;
    private JTextField noteField;
    private JTextField xCoord;
    private JTextField yCoord;
    private JRadioButton rdbtnShowBnumValues;
    private JRadioButton rdbtnShowColors;
    private JMenuBar menuBar;
    private JMenu mnAnnotations;
    private JMenuItem mntmNew;
    private JMenuItem mntmClearPrevious;
    private JMenuItem mntmClearAll;
    private ChartPanel chartPanel;
    private JFreeChart chart;
    private JLabel lblSelectBranches;
    private JTable table;
    private BranchTableModel tablemodel;
    private XYSeriesCollection datasets;
    private FtlDataRenderer newrenderer;
    private String title;
    private List<XYTextAnnotation> annotations;
    private List<XYTextAnnotation> users;
    private String userText = "";
    private boolean addingAnnotation = false;

    public FeqBranchView(BranchData bd) {
        this.initComponents();
        this.title = String.valueOf(bd.getTitle()) + " " + bd.getFilename();
        this.setTitle(this.title);
        this.datasets = bd;
        this.chart = this.createChart();
        this.chart.getTitle().setFont(new Font("Tahoma", 0, 18));
        XYPlot xyPlot = this.chart.getXYPlot();
        xyPlot.setBackgroundPaint((Paint)Color.white);
        xyPlot.setDomainGridlinesVisible(true);
        xyPlot.setRangeGridlinesVisible(true);
        xyPlot.setRangeGridlinePaint((Paint)Color.DARK_GRAY);
        xyPlot.setDomainGridlinePaint((Paint)Color.DARK_GRAY);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setPreferredSize(this.displayPanel.getPreferredSize());
        this.chartPanel.setDomainZoomable(true);
        this.chartPanel.setRangeZoomable(true);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder());
        this.chartPanel.setBorder((Border)border);
        this.displayPanel.add((Component)this.chartPanel);
        this.chartPanel.setSize(this.displayPanel.getSize());
        this.chartPanel.addChartMouseListener((ChartMouseListener)this);
        int i = 0;
        while (i < this.datasets.getSeriesCount()) {
            xyPlot.getRenderer().setSeriesVisible(i, Boolean.valueOf(false));
            ++i;
        }
        this.showColors(null);
        this.tablemodel = new BranchTableModel(this.datasets);
        this.table.setModel(this.tablemodel);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(20);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(150);
        DefaultTableCellRenderer center = new DefaultTableCellRenderer();
        center.setHorizontalAlignment(0);
        this.table.getColumnModel().getColumn(1).setCellRenderer(center);
        this.annotations = this.createAnnotations();
        this.users = new ArrayList<XYTextAnnotation>();
    }

    private void initComponents() {
        this.displayPanel = new JPanel();
        this.Dashboard = new JPanel();
        this.scroll = new JScrollPane();
        this.scroll.setVerticalScrollBarPolicy(22);
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.bnumField = new JTextField();
        this.xCoord = new JTextField();
        this.yCoord = new JTextField();
        this.jLabel4 = new JLabel();
        this.noteField = new JTextField();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.xnumField = new JTextField();
        this.rdbtnShowBnumValues = new JRadioButton();
        this.rdbtnShowColors = new JRadioButton();
        this.menuBar = new JMenuBar();
        this.mnAnnotations = new JMenu();
        this.mntmNew = new JMenuItem();
        this.mntmClearPrevious = new JMenuItem();
        this.mntmClearAll = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setMinimumSize(new Dimension(551, 412));
        this.displayPanel.setLayout(new BorderLayout());
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Click on a point for information. Drag a rectangle to zoom. Right click for more options.");
        this.jLabel2.setText("X Coordinate:");
        this.jLabel3.setText("Y Coordinate:");
        this.xCoord.setText("0");
        this.xCoord.setFocusable(true);
        this.xCoord.setEditable(false);
        this.xCoord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeqBranchView.this.xCoordActionPerformed(evt);
            }
        });
        this.yCoord.setText("0");
        this.yCoord.setFocusable(true);
        this.yCoord.setEditable(false);
        this.jLabel4.setText("Note:");
        this.noteField.setFocusable(true);
        this.noteField.setEditable(false);
        this.noteField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeqBranchView.this.noteFieldActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Xnum:");
        this.xnumField.setFocusable(true);
        this.xnumField.setEditable(false);
        this.xnumField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeqBranchView.this.xnumFieldActionPerformed(evt);
            }
        });
        this.rdbtnShowBnumValues.setText("Show Branch Numbers");
        this.rdbtnShowBnumValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeqBranchView.this.showBnumValues(evt);
            }
        });
        this.rdbtnShowColors.setText("Show Nodes and Branches");
        this.rdbtnShowColors.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeqBranchView.this.showColors(evt);
            }
        });
        this.setJMenuBar(this.menuBar);
        this.mnAnnotations.setText("Annotations");
        this.menuBar.add(this.mnAnnotations);
        this.mntmNew.setText("New");
        this.mntmNew.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.mntmNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeqBranchView.this.newAnnotation(evt);
            }
        });
        this.mnAnnotations.add(this.mntmNew);
        this.mntmClearPrevious.setText("Clear Previous");
        this.mntmClearPrevious.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.mntmClearPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeqBranchView.this.clearPrevAnnotation(evt);
            }
        });
        this.mnAnnotations.add(this.mntmClearPrevious);
        this.mntmClearAll.setText("Clear All");
        this.mntmClearAll.setAccelerator(KeyStroke.getKeyStroke(90, 3));
        this.mntmClearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeqBranchView.this.clearAllAnnotation(evt);
            }
        });
        this.mnAnnotations.add(this.mntmClearAll);
        this.bnumField = new JTextField();
        this.bnumField.setEditable(false);
        this.bnumField.setColumns(10);
        this.jLabel6.setText("Branch:");
        GroupLayout FeqxDashboardLayout = new GroupLayout(this.Dashboard);
        FeqxDashboardLayout.setHorizontalGroup(FeqxDashboardLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(FeqxDashboardLayout.createSequentialGroup().addGap(67).addComponent(this.jLabel1, -1, 420, Short.MAX_VALUE).addGap(70)).addGroup(FeqxDashboardLayout.createSequentialGroup().addGap(12).addGroup(FeqxDashboardLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(FeqxDashboardLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yCoord, 67, 67, 67)).addGroup(FeqxDashboardLayout.createSequentialGroup().addGroup(FeqxDashboardLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel6).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(FeqxDashboardLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bnumField, -1, 67, Short.MAX_VALUE).addComponent(this.xCoord)))).addGap(18).addGroup(FeqxDashboardLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(FeqxDashboardLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(FeqxDashboardLayout.createSequentialGroup().addComponent(this.rdbtnShowBnumValues).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rdbtnShowColors)).addComponent(this.xnumField, -2, 85, -2).addComponent(this.noteField, -2, 301, -2)).addContainerGap(42, Short.MAX_VALUE)));
        FeqxDashboardLayout.setVerticalGroup(FeqxDashboardLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(FeqxDashboardLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 6, Short.MAX_VALUE).addGroup(FeqxDashboardLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(FeqxDashboardLayout.createSequentialGroup().addGroup(FeqxDashboardLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bnumField, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.rdbtnShowBnumValues).addComponent(this.rdbtnShowColors)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(FeqxDashboardLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.noteField, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(FeqxDashboardLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.xnumField, -2, -1, -2).addComponent(this.jLabel5))).addGroup(FeqxDashboardLayout.createSequentialGroup().addGroup(FeqxDashboardLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.xCoord, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(FeqxDashboardLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.yCoord, -2, -1, -2)))).addGap(8)));
        this.Dashboard.setLayout(FeqxDashboardLayout);
        this.lblSelectBranches = new JLabel("Select branches to display:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.displayPanel, -1, 557, Short.MAX_VALUE).addComponent(this.Dashboard, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblSelectBranches).addComponent(this.scroll, -2, 149, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.lblSelectBranches).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scroll, -1, 415, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.displayPanel, -1, 329, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.Dashboard, -2, 100, -2))).addContainerGap()));
        this.table = new JTable();
        this.table.setShowVerticalLines(false);
        this.table.setShowHorizontalLines(false);
        this.table.setShowGrid(false);
        this.table.setSelectionMode(1);
        this.table.setFillsViewportHeight(true);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent arg0) {
                FeqBranchView.this.selectBranches(arg0);
            }
        });
        this.table.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                FeqBranchView.this.table.clearSelection();
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FeqBranchView.this.columnClick(e);
            }
        });
        this.scroll.setViewportView(this.table);
        this.getContentPane().setLayout(layout);
        this.pack();
    }

    private void xCoordActionPerformed(ActionEvent evt) {
    }

    private void noteFieldActionPerformed(ActionEvent evt) {
    }

    private void xnumFieldActionPerformed(ActionEvent evt) {
    }

    private void selectBranches(MouseEvent e) {
        int start = this.table.getSelectionModel().getMinSelectionIndex();
        int end = this.table.getSelectionModel().getMaxSelectionIndex();
        int index = 0;
        int i = start;
        while (i <= end) {
            if (this.table.isRowSelected(i)) {
                this.tablemodel.changeValueAt(i);
                index = this.datasets.indexOf((Comparable)((Object)((String)this.tablemodel.getValueAt(i, 1))));
                this.chart.getXYPlot().getRenderer().setSeriesVisible(index, Boolean.valueOf((Boolean)this.tablemodel.getValueAt(i, 0)));
            }
            ++i;
        }
        this.table.repaint();
        if (this.rdbtnShowBnumValues.isSelected()) {
            this.chart.getXYPlot().clearAnnotations();
            for (XYTextAnnotation note : this.users) {
                this.chart.getXYPlot().addAnnotation((XYAnnotation)note);
            }
            this.showBnumValues(null);
        }
    }

    private void columnClick(MouseEvent e) {
        switch (this.table.columnAtPoint(e.getPoint())) {
            case 0: {
                this.table.selectAll();
                this.selectBranches(e);
                break;
            }
            case 1: {
                this.tablemodel.reverse();
                break;
            }
            case 2: {
                break;
            }
        }
    }

    private void showColors(ActionEvent evt) {
        if (this.rdbtnShowColors.isSelected()) {
            int i = 0;
            while (i < this.datasets.getSeriesCount()) {
                switch (i % 7) {
                    case 0: {
                        this.chart.getXYPlot().getRenderer().setSeriesPaint(i, (Paint)Color.RED);
                        break;
                    }
                    case 1: {
                        this.chart.getXYPlot().getRenderer().setSeriesPaint(i, (Paint)Color.BLUE);
                        break;
                    }
                    case 2: {
                        this.chart.getXYPlot().getRenderer().setSeriesPaint(i, (Paint)Color.GREEN);
                        break;
                    }
                    case 3: {
                        this.chart.getXYPlot().getRenderer().setSeriesPaint(i, (Paint)Color.MAGENTA);
                        break;
                    }
                    case 4: {
                        this.chart.getXYPlot().getRenderer().setSeriesPaint(i, (Paint)Color.CYAN);
                        break;
                    }
                    case 5: {
                        this.chart.getXYPlot().getRenderer().setSeriesPaint(i, (Paint)Color.ORANGE);
                        break;
                    }
                    case 6: {
                        this.chart.getXYPlot().getRenderer().setSeriesPaint(i, (Paint)Color.GRAY);
                        break;
                    }
                }
                ++i;
            }
            ((FtlDataRenderer)this.chart.getXYPlot().getRenderer()).setBaseShapesVisible(true);
        } else {
            int i = 0;
            while (i < this.datasets.getSeriesCount()) {
                this.chart.getXYPlot().getRenderer().setSeriesPaint(i, (Paint)Color.RED);
                ++i;
            }
            ((FtlDataRenderer)this.chart.getXYPlot().getRenderer()).setBaseShapesVisible(false);
        }
    }

    private void showBnumValues(ActionEvent evt) {
        XYPlot xyplot = this.chart.getXYPlot();
        if (this.rdbtnShowBnumValues.isSelected()) {
            for (XYTextAnnotation note : this.annotations) {
                if (!this.chart.getXYPlot().getRenderer().isSeriesVisible(this.datasets.indexOf((Comparable)((Object)note.getText())))) continue;
                xyplot.addAnnotation((XYAnnotation)note);
            }
        } else {
            xyplot.clearAnnotations();
            for (XYTextAnnotation note : this.users) {
                xyplot.addAnnotation((XYAnnotation)note);
            }
        }
    }

    private void newAnnotation(ActionEvent evt) {
        JOptionPane annotationPane = new JOptionPane();
        this.userText = JOptionPane.showInputDialog("After entering your text, click on the chart \nwhere you want the annotations to be:\n\n");
        if (this.userText != null && !this.userText.equals("")) {
            this.addingAnnotation = true;
        }
    }

    private void clearPrevAnnotation(ActionEvent evt) {
        XYPlot xyplot = this.chart.getXYPlot();
        if (!this.users.isEmpty()) {
            xyplot.removeAnnotation((XYAnnotation)this.users.get(this.users.size() - 1));
            this.users.remove(this.users.size() - 1);
        }
    }

    private void clearAllAnnotation(ActionEvent evt) {
        XYPlot xyplot = this.chart.getXYPlot();
        for (XYTextAnnotation note : this.users) {
            xyplot.removeAnnotation((XYAnnotation)note);
        }
        this.users.clear();
    }

    private List<XYTextAnnotation> createAnnotations() {
        ArrayList<XYTextAnnotation> list = new ArrayList<XYTextAnnotation>();
        for (XYSeries set : this.datasets.getSeries()) {
            if (set.isEmpty()) continue;
            BranchDataItem item = (BranchDataItem)((Object)set.getItems().get(set.getItemCount() / 2));
            list.add(new XYTextAnnotation((String)((Object)set.getKey()), item.getXValue(), item.getYValue() + 0.5));
        }
        return list;
    }

    private JFreeChart createChart() {
        JFreeChart newchart = ChartFactory.createXYLineChart((String)this.title, (String)"Station", (String)"Elevation", (XYDataset)this.datasets, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        XYPlot xyplot = newchart.getXYPlot();
        this.newrenderer = new FtlDataRenderer();
        this.newrenderer.setUseFillPaint(true);
        this.newrenderer.setUseOutlinePaint(true);
        xyplot.setRenderer((XYItemRenderer)this.newrenderer);
        ((NumberAxis)xyplot.getRangeAxis()).setAutoRangeIncludesZero(false);
        xyplot.getRangeAxis().setAutoRange(true);
        return newchart;
    }

    public void chartMouseClicked(ChartMouseEvent arg0) {
        this.chartPanel.grabFocus();
        this.chartPanel.setSize(this.displayPanel.getSize());
        ChartEntity chartentity = arg0.getEntity();
        if (chartentity != null && chartentity instanceof XYItemEntity) {
            XYItemEntity point = (XYItemEntity)chartentity;
            BranchDataItem item = (BranchDataItem)((Object)((XYSeriesCollection)point.getDataset()).getSeries(point.getSeriesIndex()).getItems().get(point.getItem()));
            this.bnumField.setText((String)((Object)point.getDataset().getSeriesKey(point.getSeriesIndex())));
            this.xCoord.setText(String.valueOf(item.getXValue()));
            this.yCoord.setText(String.valueOf(item.getYValue()));
            this.noteField.setText(item.getNote());
            this.xnumField.setText(String.valueOf(item.getXnum()));
            this.newrenderer.setHighlightedItem(point.getSeriesIndex(), point.getItem());
        } else {
            this.bnumField.setText("");
            this.xCoord.setText("0");
            this.yCoord.setText("0");
            this.noteField.setText("");
            this.xnumField.setText("");
            this.newrenderer.setHighlightedItem(-1, -1);
        }
        if (this.addingAnnotation) {
            double x = arg0.getTrigger().getX();
            double y = arg0.getTrigger().getY();
            Rectangle2D plotArea = this.chartPanel.getScreenDataArea();
            XYPlot xyplot = this.chart.getXYPlot();
            x = xyplot.getDomainAxis().java2DToValue(x, plotArea, xyplot.getDomainAxisEdge());
            y = xyplot.getRangeAxis().java2DToValue(y, plotArea, xyplot.getRangeAxisEdge());
            XYTextAnnotation note = new XYTextAnnotation(this.userText, x, y);
            this.users.add(note);
            xyplot.addAnnotation((XYAnnotation)note);
            this.userText = "";
        }
    }

    public void chartMouseMoved(ChartMouseEvent arg0) {
    }
}

