/*
 * Decompiled with CFR 0.152.
 */
package fequtl;

import fequtl.CulvertData;
import fequtl.FeqCommand;
import fequtl.FeqxData;
import fequtl.MulconData;
import fequtl.ParsingException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FeqFtlData {
    private List<FeqCommand> data = new ArrayList<FeqCommand>();

    public List<FeqCommand> getData() {
        return this.data;
    }

    public void importData(String filename) throws ParsingException {
        File inputFile = new File(filename);
        int numParsed = 0;
        try {
            String line;
            LineNumberReader br = new LineNumberReader(new FileReader(inputFile));
            while ((line = br.readLine()) != null) {
                if (line.startsWith(";")) continue;
                if (line.split("\\s").length > 0 && line.split("\\s")[0].trim().equalsIgnoreCase("FEQX") && !line.matches("FEQX        1")) {
                    FeqxData feqx = new FeqxData(inputFile.getName());
                    try {
                        ((FeqCommand)feqx).parseData(br);
                    }
                    catch (Exception e) {
                        throw new ParsingException("Problem parsing " + inputFile.getName() + " at line " + br.getLineNumber(), numParsed);
                    }
                    this.data.add(feqx);
                    ++numParsed;
                    continue;
                }
                if (line.split("\\s").length > 0 && line.split("\\s")[0].trim().equalsIgnoreCase("CULVERT") && !line.matches("CULVERT     4")) {
                    CulvertData culvert = new CulvertData(inputFile.getName());
                    try {
                        ((FeqCommand)culvert).parseData(br);
                    }
                    catch (Exception e) {
                        throw new ParsingException("Problem parsing " + inputFile.getName() + " at line " + br.getLineNumber(), numParsed);
                    }
                    this.data.add(culvert);
                    ++numParsed;
                    continue;
                }
                if (line.split("\\s").length <= 0 || !line.split("\\s")[0].trim().equalsIgnoreCase("MULCON") || line.matches("MULCON     18")) continue;
                MulconData mulcon = new MulconData(inputFile.getName());
                try {
                    ((FeqCommand)mulcon).parseData(br);
                }
                catch (Exception e) {
                    throw new ParsingException("Problem parsing " + inputFile.getName() + " at line " + br.getLineNumber(), numParsed);
                }
                this.data.add(mulcon);
                ++numParsed;
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(FeqFtlData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(FeqFtlData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

