/*
 * Decompiled with CFR 0.152.
 */
package fequtl;

import fequtl.PrintJTable;
import fequtl.TABNumberCellRenderer;
import fequtl.TabData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class FeqTabView
extends JFrame {
    public FeqTabView(TabData td) {
        super(String.valueOf(td.getTitle()) + " " + td.getFilename());
        FeqPanel d = new FeqPanel(String.valueOf(td.getTitle()) + " " + td.getFilename(), td);
        this.setMinimumSize(d.getMinimumSize());
        this.setContentPane(d);
    }

    static class DemoTableModel
    extends AbstractTableModel
    implements TableModel {
        XYSeriesCollection input;
        private Object[][] data;

        public DemoTableModel(XYSeriesCollection input) {
            this.input = input;
            this.data = new Object[input.getItemCount(0)][input.getSeries().size()];
        }

        @Override
        public int getColumnCount() {
            return this.input.getSeries().size();
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.input.getX(column, row);
        }

        @Override
        public String getColumnName(int column) {
            XYSeries s = (XYSeries)this.input.getSeries().get(column);
            return (String)((Object)s.getKey());
        }
    }

    private static class FeqPanel
    extends JPanel
    implements ActionListener {
        private XYSeriesCollection datasets;
        private ChartPanel chartPanel;
        private DemoTableModel model;
        private XYSeriesCollection input;
        private XYItemRenderer renderer;
        private String title;
        private JTable table;

        public FeqPanel(String title, XYSeriesCollection input) {
            super(new BorderLayout());
            this.title = title;
            this.input = input;
            this.datasets = new XYSeriesCollection();
            this.createDataset();
            JFreeChart chart = this.createChart();
            Plot plot = chart.getPlot();
            plot.setBackgroundPaint((Paint)Color.white);
            XYPlot xyPlot = chart.getXYPlot();
            xyPlot.setDomainGridlinesVisible(true);
            xyPlot.setRangeGridlinesVisible(true);
            xyPlot.setRangeGridlinePaint((Paint)Color.DARK_GRAY);
            xyPlot.setDomainGridlinePaint((Paint)Color.DARK_GRAY);
            this.chartPanel = new ChartPanel(chart);
            this.chartPanel.setPreferredSize(new Dimension(600, 270));
            this.chartPanel.setDomainZoomable(true);
            this.chartPanel.setRangeZoomable(true);
            CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder());
            this.chartPanel.setBorder((Border)border);
            chart.setTitle(title);
            this.renderer.setSeriesPaint(0, (Paint)Color.RED);
            this.renderer.setSeriesPaint(1, (Paint)new Color(156, 93, 82));
            this.renderer.setSeriesPaint(2, (Paint)Color.BLACK);
            this.renderer.setSeriesPaint(3, (Paint)Color.MAGENTA);
            this.renderer.setSeriesPaint(4, (Paint)Color.BLUE);
            this.renderer.setSeriesPaint(5, (Paint)Color.GREEN);
            this.renderer.setSeriesPaint(6, (Paint)Color.ORANGE);
            this.renderer.setSeriesPaint(7, (Paint)Color.CYAN);
            this.renderer.setSeriesPaint(8, (Paint)Color.GRAY);
            JPanel jpanel = new JPanel();
            int i = 0;
            JButton pTable = new JButton("Print Table");
            pTable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PrintJTable.printTable(FeqPanel.this.table);
                }
            });
            jpanel.add(pTable);
            for (XYSeries s : this.input.getSeries()) {
                String name = (String)((Object)s.getKey());
                this.renderer.setSeriesVisible(i, new Boolean(false));
                if (!name.equalsIgnoreCase("depth")) {
                    JCheckBox jcheckbox = new JCheckBox(name);
                    jcheckbox.setActionCommand("S" + i);
                    jcheckbox.addActionListener(this);
                    if (name.toLowerCase().contains("width")) {
                        jcheckbox.setSelected(true);
                        this.renderer.setSeriesVisible(i, new Boolean(true));
                    }
                    jpanel.add(jcheckbox);
                }
                ++i;
            }
            this.add((Component)jpanel, "South");
            JPanel dashboard = new JPanel(new BorderLayout());
            dashboard.setPreferredSize(new Dimension(400, 120));
            dashboard.setBorder(BorderFactory.createEmptyBorder(0, 4, 4, 4));
            this.model = new DemoTableModel(this.datasets);
            this.table = new JTable(this.model);
            this.table.setColumnSelectionAllowed(true);
            this.table.setRowSelectionAllowed(true);
            this.table.setName(title);
            TABNumberCellRenderer renderer2 = new TABNumberCellRenderer();
            int c = 0;
            while (c < this.table.getColumnCount()) {
                this.table.getColumnModel().getColumn(c).setCellRenderer(renderer2);
                ++c;
            }
            dashboard.add(new JScrollPane(this.table));
            JSplitPane content = new JSplitPane(0, (Component)this.chartPanel, dashboard);
            this.chartPanel.setMinimumSize(this.chartPanel.getPreferredSize());
            dashboard.setMinimumSize(dashboard.getPreferredSize());
            this.table.setMinimumSize(dashboard.getPreferredSize());
            this.add(content);
            Dimension minimumSize = new Dimension(this.chartPanel.getMinimumSize().width, this.chartPanel.getMinimumSize().height + dashboard.getMinimumSize().height + 50);
            this.setMinimumSize(minimumSize);
        }

        private void createDataset() {
            for (XYSeries s : this.input.getSeries()) {
                this.datasets.addSeries(s);
            }
        }

        private JFreeChart createChart() {
            JFreeChart chart = ChartFactory.createXYLineChart(null, (String)"Units", (String)"Depth", (XYDataset)this.datasets, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            XYPlot xyplot = chart.getXYPlot();
            this.renderer = xyplot.getRenderer(0);
            return chart;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int byte0 = -1;
            String action = e.getActionCommand();
            if (action.charAt(0) == 'S') {
                byte0 = Byte.parseByte(action.substring(1));
            }
            if (byte0 >= 0) {
                boolean flag = this.renderer.getItemVisible(byte0, 0);
                this.renderer.setSeriesVisible(byte0, new Boolean(!flag));
            }
        }
    }
}

