/*
 * Decompiled with CFR 0.152.
 */
package fequtl;

import fequtl.FeqCommand;
import fequtl.FeqxXYDataItem;
import fequtl.State;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYSeries;

public class FeqxData
extends FeqCommand {
    private String filename;
    private String gisid;
    private final String gisidSearch = "GISID";
    private String id;
    private final String idSearch = ".*(TABID|TABLE#).*";
    private double stat;
    private final String statSearch = "STATION";
    private double left;
    private final String leftSearch = "LEFT";
    private double right;
    private final String rightSearch = "RIGHT";
    private int navm;
    private final String navmSearch = "NAVM";
    private double scale;
    private final String scaleSearch = "SCALE";
    private double shift;
    private final String shiftSearch = "SHIFT";
    private List<Double> nsub;
    private final String nsubSearch = "NSUB";
    private String head;
    private final int[] dataColWidths = new int[]{10, 20, 25};

    public FeqxData(String filename) {
        this.filename = filename;
    }

    @Override
    public String getTitle() {
        return this.id;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDesc() {
        return this.head;
    }

    @Override
    public void parseData(LineNumberReader br) {
        try {
            String line;
            int prevNIndex = -1;
            XYSeries series = null;
            State s = State.HEADER;
            block8: while ((line = br.readLine()) != null) {
                if (line.startsWith(";") || line.startsWith("*")) continue;
                switch (s) {
                    case HEADER: {
                        int i;
                        if (line.startsWith("GISID")) {
                            this.gisid = line.substring(line.indexOf("GISID") + "GISID".length() + 1).trim();
                            break;
                        }
                        if (line.matches(".*(TABID|TABLE#).*")) {
                            int offset = line.contains("TABID") ? 6 : 7;
                            this.id = line.substring(line.indexOf("TAB") + offset).trim().split("\\s+")[0];
                            series = new XYSeries((Comparable)((Object)this.id), false);
                            break;
                        }
                        if (line.startsWith("STATION")) {
                            String[] statSplit = line.split("=");
                            i = 0;
                            while (i < statSplit.length - 1) {
                                if (statSplit[i].contains("STATION")) {
                                    this.stat = Double.parseDouble(statSplit[i + 1].trim().split("\\s+")[0]);
                                } else if (statSplit[i].contains("LEFT")) {
                                    this.left = Double.parseDouble(statSplit[i + 1].trim().split("\\s+")[0]);
                                } else if (statSplit[i].contains("RIGHT")) {
                                    this.right = Double.parseDouble(statSplit[i + 1].trim().split("\\s+")[0]);
                                }
                                ++i;
                            }
                            continue block8;
                        }
                        if (line.startsWith("NAVM")) {
                            String[] navmSplit = line.split("(=|\\s)\\s*");
                            i = 0;
                            while (i < navmSplit.length - 1) {
                                if (navmSplit[i].contains("NAVM")) {
                                    this.navm = Integer.parseInt(navmSplit[i + 1]);
                                } else if (navmSplit[i].contains("SCALE")) {
                                    this.scale = Double.parseDouble(navmSplit[i + 1]);
                                } else if (navmSplit[i].contains("SHIFT")) {
                                    this.shift = Double.parseDouble(navmSplit[i + 1]);
                                }
                                i += 2;
                            }
                            continue block8;
                        }
                        if (!line.startsWith("NSUB")) break;
                        this.nsub = new ArrayList<Double>();
                        String[] nsubSplit = line.split("\\s+");
                        i = 2;
                        while (i < nsubSplit.length) {
                            this.nsub.add(Double.parseDouble(nsubSplit[i]));
                            ++i;
                        }
                        int n = Integer.parseInt(nsubSplit[1]);
                        while (this.nsub.size() < n) {
                            line = br.readLine().trim();
                            nsubSplit = line.split("\\s+");
                            int i2 = 0;
                            while (i2 < nsubSplit.length) {
                                this.nsub.add(Double.parseDouble(nsubSplit[i2]));
                                ++i2;
                            }
                        }
                        this.head = br.readLine();
                        s = State.DATA;
                        break;
                    }
                    case DATA: {
                        int nIndex;
                        if (line.isEmpty()) {
                            this.data.addSeries(series);
                            return;
                        }
                        List thisdata = this.splitString(line);
                        FeqxXYDataItem thispoint = new FeqxXYDataItem(Double.parseDouble((String)thisdata.get(0)), Double.parseDouble((String)thisdata.get(1)));
                        try {
                            nIndex = Integer.parseInt((String)thisdata.get(2));
                        }
                        catch (Exception ex) {
                            nIndex = prevNIndex;
                        }
                        if (nIndex > this.nsub.size()) {
                            nIndex = prevNIndex;
                        }
                        prevNIndex = nIndex;
                        thispoint.setN(nIndex > 0 ? this.nsub.get(nIndex - 1) : -1.0);
                        if (thisdata.size() == 4) {
                            thispoint.setNote((String)thisdata.get(3));
                        }
                        series.add((XYDataItem)thispoint);
                        if (!line.contains(" -1 ") && !line.endsWith("-1")) continue block8;
                        this.data.addSeries(series);
                        return;
                    }
                }
            }
        }
        catch (IOException ex) {
            Logger.getLogger(FeqxData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private List splitString(String input) {
        int prev = 0;
        ArrayList<String> l = new ArrayList<String>();
        int[] nArray = this.dataColWidths;
        int n = this.dataColWidths.length;
        int n2 = 0;
        while (n2 < n) {
            int w = nArray[n2];
            try {
                l.add(input.substring(prev, w).trim());
            }
            catch (IndexOutOfBoundsException e) {
                Logger.getLogger(FeqxData.class.getName()).log(Level.SEVERE, null, e);
            }
            prev = w;
            ++n2;
        }
        try {
            l.add(input.substring(prev).trim());
        }
        catch (IndexOutOfBoundsException e) {
            Logger.getLogger(FeqxData.class.getName()).log(Level.SEVERE, null, e);
        }
        return l;
    }

    @Override
    public String getType() {
        return "FEQX";
    }
}

