/*
 * Decompiled with CFR 0.152.
 */
package fequtl;

import fequtl.FeqCommand;
import fequtl.FeqxXYDataItem;
import fequtl.FtlDataRenderer;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.AbstractXYAnnotation;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYLineAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeriesCollection;

public class FeqxFtlView
extends JFrame
implements ChartMouseListener {
    private JPanel FeqxDashboard;
    private JPanel displayPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JTextField nField;
    private JTextField noteField;
    private JTextField xCoord;
    private JTextField yCoord;
    private JRadioButton rdbtnShowNValues;
    private JMenuBar menuBar;
    private JMenu mnAnnotations;
    private JMenuItem mntmNew;
    private JMenuItem mntmClearPrevious;
    private JMenuItem mntmClearAll;
    private XYSeriesCollection datasets;
    private ChartPanel chartPanel;
    private FtlDataRenderer newrenderer;
    private String title;
    private JFreeChart chart;
    private List<AbstractXYAnnotation> annotations;
    private String userText = "";
    private boolean addingAnnotation = false;

    public FeqxFtlView(FeqCommand input) {
        this.initComponents();
        this.title = String.valueOf(input.getTitle()) + " " + input.getFilename();
        this.setTitle(this.title);
        this.datasets = input.getData();
        this.chart = this.createChart();
        Plot plot = this.chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        XYPlot xyPlot = this.chart.getXYPlot();
        xyPlot.setDomainGridlinesVisible(true);
        xyPlot.setRangeGridlinesVisible(true);
        xyPlot.setRangeGridlinePaint((Paint)Color.DARK_GRAY);
        xyPlot.setDomainGridlinePaint((Paint)Color.DARK_GRAY);
        this.chartPanel = new ChartPanel(this.chart);
        this.chartPanel.setPreferredSize(this.displayPanel.getPreferredSize());
        this.chartPanel.setDomainZoomable(true);
        this.chartPanel.setRangeZoomable(true);
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createEtchedBorder());
        this.chartPanel.setBorder((Border)border);
        this.displayPanel.add((Component)this.chartPanel);
        this.chartPanel.setSize(this.displayPanel.getSize());
        this.chartPanel.addChartMouseListener((ChartMouseListener)this);
        this.chart.removeLegend();
        this.chart.setTitle(this.title);
        this.annotations = this.createAnnotations();
    }

    private void initComponents() {
        this.displayPanel = new JPanel();
        this.FeqxDashboard = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.xCoord = new JTextField();
        this.yCoord = new JTextField();
        this.jLabel4 = new JLabel();
        this.noteField = new JTextField();
        this.jLabel5 = new JLabel();
        this.nField = new JTextField();
        this.rdbtnShowNValues = new JRadioButton();
        this.menuBar = new JMenuBar();
        this.mnAnnotations = new JMenu();
        this.mntmNew = new JMenuItem();
        this.mntmClearPrevious = new JMenuItem();
        this.mntmClearAll = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setMinimumSize(new Dimension(551, 412));
        this.displayPanel.setLayout(new BorderLayout());
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Click on a point for information. Drag a rectangle to zoom. Right click for more options.");
        this.jLabel2.setText("X Coordinate:");
        this.jLabel3.setText("Y Coordinate:");
        this.xCoord.setText("0");
        this.xCoord.setFocusable(true);
        this.xCoord.setEditable(false);
        this.xCoord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeqxFtlView.this.xCoordActionPerformed(evt);
            }
        });
        this.yCoord.setText("0");
        this.yCoord.setFocusable(true);
        this.yCoord.setEditable(false);
        this.jLabel4.setText("Note:");
        this.noteField.setFocusable(true);
        this.noteField.setEditable(false);
        this.noteField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeqxFtlView.this.noteFieldActionPerformed(evt);
            }
        });
        this.jLabel5.setText("N Value:");
        this.nField.setFocusable(true);
        this.nField.setEditable(false);
        this.nField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeqxFtlView.this.nFieldActionPerformed(evt);
            }
        });
        this.rdbtnShowNValues.setText("Show N Values");
        this.rdbtnShowNValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeqxFtlView.this.showNValues(evt);
            }
        });
        this.setJMenuBar(this.menuBar);
        this.mnAnnotations.setText("Annotations");
        this.menuBar.add(this.mnAnnotations);
        this.mntmNew.setText("New");
        this.mntmNew.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.mntmNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeqxFtlView.this.newAnnotation(evt);
            }
        });
        this.mnAnnotations.add(this.mntmNew);
        this.mntmClearPrevious.setText("Clear Previous");
        this.mntmClearPrevious.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.mntmClearPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeqxFtlView.this.clearPrevAnnotation(evt);
            }
        });
        this.mnAnnotations.add(this.mntmClearPrevious);
        this.mntmClearAll.setText("Clear All");
        this.mntmClearAll.setAccelerator(KeyStroke.getKeyStroke(90, 3));
        this.mntmClearAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FeqxFtlView.this.clearAllAnnotation(evt);
            }
        });
        this.mnAnnotations.add(this.mntmClearAll);
        GroupLayout FeqxDashboardLayout = new GroupLayout(this.FeqxDashboard);
        FeqxDashboardLayout.setHorizontalGroup(FeqxDashboardLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(FeqxDashboardLayout.createSequentialGroup().addContainerGap().addGroup(FeqxDashboardLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(FeqxDashboardLayout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yCoord)).addGroup(FeqxDashboardLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xCoord, -2, 60, -2))).addGap(36).addGroup(FeqxDashboardLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(FeqxDashboardLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(FeqxDashboardLayout.createSequentialGroup().addComponent(this.nField, -2, 69, -2).addGap(18).addComponent(this.rdbtnShowNValues)).addComponent(this.noteField, -2, 301, -2)).addGap(13)).addGroup(FeqxDashboardLayout.createSequentialGroup().addGap(67).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGap(70)));
        FeqxDashboardLayout.setVerticalGroup(FeqxDashboardLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(FeqxDashboardLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(FeqxDashboardLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.xCoord, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.noteField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(FeqxDashboardLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.yCoord, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.nField, -2, -1, -2).addComponent(this.rdbtnShowNValues)).addContainerGap(-1, Short.MAX_VALUE)));
        this.FeqxDashboard.setLayout(FeqxDashboardLayout);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.FeqxDashboard, 0, -1, Short.MAX_VALUE).addComponent(this.displayPanel, -1, 551, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.displayPanel, -1, 329, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.FeqxDashboard, -2, -1, -2)));
        this.pack();
    }

    private void xCoordActionPerformed(ActionEvent evt) {
    }

    private void noteFieldActionPerformed(ActionEvent evt) {
    }

    private void nFieldActionPerformed(ActionEvent evt) {
    }

    private void showNValues(ActionEvent evt) {
        XYPlot xyplot = this.chart.getXYPlot();
        if (this.rdbtnShowNValues.isSelected()) {
            for (AbstractXYAnnotation note : this.annotations) {
                xyplot.addAnnotation((XYAnnotation)note);
            }
        } else {
            List current = xyplot.getAnnotations();
            xyplot.clearAnnotations();
            int i = 0;
            for (AbstractXYAnnotation note : current) {
                if (note.equals((Object)this.annotations.get(i))) {
                    ++i;
                    continue;
                }
                xyplot.addAnnotation((XYAnnotation)note);
            }
        }
    }

    private void newAnnotation(ActionEvent evt) {
        JOptionPane annotationPane = new JOptionPane();
        this.userText = JOptionPane.showInputDialog("After entering your text, click on the chart \nwhere you want the annotations to be:\n\n");
        if (this.userText != null && !this.userText.equals("")) {
            this.addingAnnotation = true;
        }
    }

    private void clearPrevAnnotation(ActionEvent evt) {
        XYPlot xyplot = this.chart.getXYPlot();
        List current = xyplot.getAnnotations();
        if (!current.isEmpty() && !current.equals(this.annotations)) {
            if (((AbstractXYAnnotation)current.get(current.size() - 1)).equals((Object)this.annotations.get(this.annotations.size() - 1))) {
                current.remove(current.size() - 1 - this.annotations.size());
            } else {
                current.remove(current.size() - 1);
            }
            xyplot.clearAnnotations();
            for (AbstractXYAnnotation note : current) {
                xyplot.addAnnotation((XYAnnotation)note);
            }
        }
    }

    private void clearAllAnnotation(ActionEvent evt) {
        XYPlot xyplot = this.chart.getXYPlot();
        xyplot.clearAnnotations();
        this.showNValues(evt);
    }

    public void chartMouseClicked(ChartMouseEvent event) {
        this.chartPanel.setSize(this.displayPanel.getSize());
        ChartEntity chartentity = event.getEntity();
        if (chartentity != null && chartentity instanceof XYItemEntity) {
            XYItemEntity point = (XYItemEntity)chartentity;
            FeqxXYDataItem item = (FeqxXYDataItem)((Object)((XYSeriesCollection)point.getDataset()).getSeries(0).getItems().get(point.getItem()));
            this.xCoord.setText(String.valueOf(item.getXValue()));
            this.yCoord.setText(String.valueOf(item.getYValue()));
            this.noteField.setText(item.getNote());
            this.nField.setText(String.valueOf(item.getN()));
            this.newrenderer.setHighlightedItem(point.getSeriesIndex(), point.getItem());
        } else {
            this.xCoord.setText("0");
            this.yCoord.setText("0");
            this.noteField.setText("");
            this.nField.setText("");
            this.newrenderer.setHighlightedItem(-1, -1);
        }
        if (this.addingAnnotation) {
            double x = event.getTrigger().getX();
            double y = event.getTrigger().getY();
            Rectangle2D plotArea = this.chartPanel.getScreenDataArea();
            XYPlot xyplot = this.chart.getXYPlot();
            x = xyplot.getDomainAxis().java2DToValue(x, plotArea, xyplot.getDomainAxisEdge());
            y = xyplot.getRangeAxis().java2DToValue(y, plotArea, xyplot.getRangeAxisEdge());
            xyplot.addAnnotation((XYAnnotation)new XYTextAnnotation(this.userText, x, y));
            this.userText = "";
        }
    }

    public void chartMouseMoved(ChartMouseEvent event) {
    }

    private JFreeChart createChart() {
        JFreeChart newchart = ChartFactory.createXYLineChart(null, (String)"Distance", (String)"Depth", (XYDataset)this.datasets, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot xyplot = newchart.getXYPlot();
        this.newrenderer = new FtlDataRenderer();
        this.newrenderer.setUseFillPaint(true);
        this.newrenderer.setUseOutlinePaint(true);
        xyplot.setRenderer((XYItemRenderer)this.newrenderer);
        ((NumberAxis)xyplot.getRangeAxis()).setAutoRangeIncludesZero(false);
        xyplot.getRangeAxis().setAutoRange(true);
        return newchart;
    }

    private List<AbstractXYAnnotation> createAnnotations() {
        ArrayList<AbstractXYAnnotation> list = new ArrayList<AbstractXYAnnotation>();
        List myitems = this.datasets.getSeries(0).getItems();
        BasicStroke line = new BasicStroke(0.3f);
        double[] x = new double[myitems.size()];
        double[] y = new double[myitems.size()];
        double[] N = new double[myitems.size()];
        int i = 0;
        int istart = 0;
        double ymax = 0.0;
        for (FeqxXYDataItem item : myitems) {
            x[i] = item.getXValue();
            y[i] = item.getYValue();
            N[i] = item.getN();
            ymax = ymax < y[i] ? y[i] : ymax;
            ++i;
        }
        list.add((AbstractXYAnnotation)new XYLineAnnotation(x[0], ymax, x[myitems.size() - 1], ymax, (Stroke)line, (Paint)Color.BLACK));
        list.add((AbstractXYAnnotation)new XYLineAnnotation(x[0], y[0], x[0], ymax, (Stroke)line, (Paint)Color.BLACK));
        i = 1;
        while (i < myitems.size()) {
            if (Math.abs(N[i - 1] - N[i]) > 1.0E-5) {
                list.add((AbstractXYAnnotation)new XYLineAnnotation(x[i], y[i], x[i], ymax, (Stroke)line, (Paint)Color.BLACK));
                XYTextAnnotation xyta = new XYTextAnnotation(Double.toString(N[istart]), (x[istart] + x[i]) / 2.0, ymax + 0.25);
                xyta.setRotationAngle(-0.7853975);
                list.add((AbstractXYAnnotation)xyta);
                istart = i;
            }
            ++i;
        }
        return list;
    }
}

