/*
 * Decompiled with CFR 0.152.
 */
package fequtl;

import fequtl.FeqCommand;
import fequtl.Pipe;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MulconData
extends FeqCommand {
    private String filename;
    private String id;
    private String desc;
    private final String idSearch = ".*(TABID|TABLE#).*";
    private String wslot;
    private final String wslotSearch = "WSLOT";
    private String hslot;
    private final String hslotSearch = "HSLOT";
    private int npipes;
    private final String npipesSearch = "NPIPES";
    private Pipe[] pipes;
    private final String typeSearch = "TYPE";
    private final String spanSearch = "SPAN";
    private final String riseSearch = "RISE";
    private final String bottSearch = "BOTT";
    private final String rougSearch = "(ROUG|ROGH).*";
    private List<Integer> columnwidths = new ArrayList<Integer>();

    public MulconData(String filename) {
        this.filename = filename;
    }

    public Pipe[] getPipes() {
        return this.pipes;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void parseData(LineNumberReader br) {
lbl1:
        // 5 sources

        try {
            while ((line = br.readLine()) != null) {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                if (line.startsWith(";") || line.startsWith("*")) continue;
                                if (line.matches(".*(TABID|TABLE#).*")) {
                                    offset = line.contains("TABID") != false ? 6 : 7;
                                    this.id = line.substring(line.indexOf("TAB") + offset).trim().split("\\s+")[0];
                                    line = line.substring(line.indexOf("TAB") + offset).trim();
                                    this.desc = line.substring(line.indexOf(" ") + 1);
                                    continue;
                                }
                                if (line.startsWith("WSLOT")) {
                                    this.wslot = line.substring(line.indexOf("WSLOT") + "WSLOT".length() + 1).trim();
                                    continue;
                                }
                                if (line.startsWith("HSLOT")) {
                                    this.hslot = line.substring(line.indexOf("HSLOT") + "HSLOT".length() + 1).trim();
                                    continue;
                                }
                                if (line.startsWith("NPIPES")) {
                                    this.npipes = Integer.parseInt(line.substring(line.indexOf("NPIPES") + "NPIPES".length() + 1).trim().split("\\s+")[0]);
                                    this.pipes = new Pipe[this.npipes];
                                    continue;
                                }
                                if (!line.startsWith("TYPE")) break block18;
                                types = line.substring(line.indexOf("TYPE") + "TYPE".length() + 1).trim().split("\\s+");
                                i = 0;
                                while (i < this.pipes.length) {
                                    this.pipes[i] = new Pipe();
                                    try {
                                        this.pipes[i].setType(MulconType.valueOf(types[i]));
                                    }
                                    catch (Exception ex) {
                                        this.pipes[i].setType(MulconType.valueOf("OTHER"));
                                    }
                                    ++i;
                                }
                                this.columnwidths.add(line.indexOf("TYPE") + "TYPE".length() + 1);
                                i = 0;
                                while (i < types.length - 1) {
                                    center = line.indexOf(types[i]) + types[i].length();
                                    line = line.replaceFirst(types[i], types[i].replaceAll("\\w", " "));
                                    this.columnwidths.add((center += line.indexOf(types[i + 1])) / 2);
                                    ++i;
                                }
                                ** GOTO lbl1
                            }
                            if (!line.startsWith("SPAN")) break block19;
                            spans = this.splitColumns(line);
                            i = 0;
                            while (i < this.pipes.length) {
                                this.pipes[i].setSpan(Double.parseDouble(spans[i]));
                                ++i;
                            }
                            ** GOTO lbl1
                        }
                        if (!line.startsWith("RISE")) break block20;
                        rises = this.splitColumns(line);
                        i = 0;
                        while (i < this.pipes.length) {
                            if (!rises[i].equals("")) {
                                this.pipes[i].setRise(Double.parseDouble(rises[i]));
                            } else {
                                this.pipes[i].setRise(this.pipes[i].getSpan());
                            }
                            ++i;
                        }
                        ** GOTO lbl1
                    }
                    if (!line.startsWith("BOTT")) break block21;
                    botts = this.splitColumns(line);
                    i = 0;
                    while (i < this.pipes.length) {
                        this.pipes[i].setBott(Double.parseDouble(botts[i]));
                        ++i;
                    }
                    ** GOTO lbl1
                }
                if (line.matches("(ROUG|ROGH).*")) {
                    rougs = this.splitColumns(line);
                    i = 0;
                    while (i < this.pipes.length) {
                        this.pipes[i].setRoug(Double.parseDouble(rougs[i]));
                        ++i;
                    }
                    return;
                }
                if (!line.trim().equals("")) continue;
                return;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MulconData.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private String[] splitColumns(String line) {
        String[] values = new String[this.columnwidths.size()];
        int i = 0;
        while (i < values.length - 1) {
            try {
                values[i] = line.substring(this.columnwidths.get(i), this.columnwidths.get(i + 1) - 1).trim();
            }
            catch (Exception e) {
                values[i] = "";
            }
            ++i;
        }
        try {
            values[i] = line.substring(this.columnwidths.get(i)).trim();
        }
        catch (Exception e) {
            values[i] = "";
        }
        return values;
    }

    @Override
    public String getTitle() {
        return this.id;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    @Override
    public String getType() {
        return "MULCON";
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public static enum MulconType {
        CIRC,
        NHE,
        NVE,
        TE,
        RCPA,
        BOX,
        CMPA,
        CMPAB,
        CMPA1,
        CMPA1B,
        SPPA18,
        SPPA31,
        OTHER;

    }
}

