/*
 * Decompiled with CFR 0.152.
 */
package fequtl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.JTable;
import javax.swing.RepaintManager;

public class PrintJTable
implements Printable {
    private JTable table;

    public static void printTable(JTable table) {
        new PrintJTable(table).print();
    }

    public PrintJTable(JTable table) {
        this.table = table;
    }

    public void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    @Override
    public int print(Graphics gc, PageFormat pf, int pageNum) throws PrinterException {
        this.table.setSize(new Dimension(575, 575));
        this.table.validate();
        Graphics2D g2 = (Graphics2D)gc;
        Rectangle clip = g2.getClipBounds();
        int fontHeight = g2.getFontMetrics().getHeight();
        double pageHeight = pf.getImageableHeight() - (double)fontHeight;
        double pageWidth = pf.getImageableWidth();
        double tableWidth = this.table.getColumnModel().getTotalColumnWidth();
        double scale = 1.0;
        String tableTitle = this.table.getName();
        g2.drawString(tableTitle, (int)pageWidth / 2 - tableTitle.length() * 3, fontHeight);
        if (tableWidth >= pageWidth) {
            scale = pageWidth / tableWidth;
        }
        double headerHeightOnPage = (double)this.table.getTableHeader().getHeight() * scale;
        double tableWidthOnPage = tableWidth * scale;
        double oneRowHeight = (double)this.table.getRowHeight() * scale;
        int numRowsOnAPage = (int)((pageHeight - headerHeightOnPage) / oneRowHeight);
        double pageHeightForTable = oneRowHeight * (double)numRowsOnAPage;
        int totalNumPages = (int)Math.ceil((double)this.table.getRowCount() / (double)numRowsOnAPage);
        if (pageNum >= totalNumPages) {
            return 1;
        }
        g2.translate(pf.getImageableX(), pf.getImageableY());
        g2.translate((pageWidth - tableWidthOnPage) / 2.0, (double)(fontHeight + 10));
        g2.setClip(0, 0, (int)tableWidthOnPage, (int)headerHeightOnPage);
        g2.scale(scale, scale);
        this.table.getTableHeader().print(g2);
        g2.scale(1.0 / scale, 1.0 / scale);
        g2.setColor(Color.gray);
        g2.drawRect(0, 0, (int)Math.ceil(tableWidthOnPage - 1.0), (int)headerHeightOnPage);
        g2.translate(0.0, headerHeightOnPage);
        g2.translate(0.0, (double)(-pageNum) * pageHeightForTable);
        if (pageNum + 1 == totalNumPages) {
            int lastRowPrinted = numRowsOnAPage * pageNum;
            int numRowsLeft = this.table.getRowCount() - lastRowPrinted;
            g2.setClip(0, (int)(pageHeightForTable * (double)pageNum), (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(oneRowHeight * (double)numRowsLeft));
        } else {
            g2.setClip(0, (int)(pageHeightForTable * (double)pageNum), (int)Math.ceil(tableWidthOnPage), (int)Math.ceil(pageHeightForTable));
        }
        g2.scale(scale, scale);
        this.table.print(g2);
        g2.scale(1.0 / scale, 1.0 / scale);
        Rectangle tableBorder = g2.getClipBounds();
        g2.setColor(Color.gray);
        g2.scale(scale, scale);
        g2.drawLine(0, tableBorder.y, 0, tableBorder.y + (int)((double)tableBorder.height / scale) - 2);
        g2.scale(1.0 / scale, 1.0 / scale);
        g2.setClip(clip);
        return 0;
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }
}

